/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui.i18n;

import java.util.ArrayList;
import java.util.List;
import technology.rocketjump.undermount.entities.model.physical.humanoid.Gender;
import technology.rocketjump.undermount.ui.i18n.I18nWordClass;

public class I18nKey {
    public final String key;
    public final I18nWordClass wordClass;
    public final Gender gender;
    public static final List<String> knownSuffixes = new ArrayList<String>();

    I18nKey(String keyString) {
        for (String knownSuffix : knownSuffixes) {
            if (!keyString.endsWith(knownSuffix)) continue;
            this.key = keyString.substring(0, keyString.lastIndexOf(knownSuffix));
            String suffix = keyString.substring(keyString.lastIndexOf(knownSuffix) + 1, keyString.length());
            if (suffix.contains("_")) {
                String[] split = suffix.split("_");
                this.gender = Gender.valueOf(split[0]);
                this.wordClass = I18nWordClass.valueOf(split[1]);
            } else {
                this.gender = Gender.ANY;
                this.wordClass = I18nWordClass.valueOf(suffix);
            }
            return;
        }
        this.wordClass = I18nWordClass.UNSPECIFIED;
        this.gender = Gender.ANY;
        this.key = keyString;
    }

    static {
        for (I18nWordClass wordClass : I18nWordClass.values()) {
            if (wordClass.equals((Object)I18nWordClass.UNSPECIFIED)) continue;
            knownSuffixes.add("." + Gender.MALE.name() + "_" + wordClass.name());
            knownSuffixes.add("." + Gender.FEMALE.name() + "_" + wordClass.name());
            knownSuffixes.add("." + wordClass.name());
        }
    }
}

